using UnityEngine;

public class Launcher : MonoBehaviour
{
    public GameObject missilePrefab;
    public Transform launchPoint;
    public string targetTag = "Enemy";

    private float inputDelay = 0.2f; // Verzgerung in Sekunden
    private float timeSinceStart = 0f;

    void Update()
    {
        timeSinceStart += Time.deltaTime;

        if (timeSinceStart >= inputDelay)
        {
            HandleInput();
        }
    }

    void HandleInput()
    {
        if (Input.GetButtonDown("Fire1"))
        {
            Debug.Log("Fire1 gedrckt");
            LaunchMissile();
        }
    }

    void LaunchMissile()
    {
        if (missilePrefab != null && launchPoint != null)
        {
            GameObject missile = Instantiate(missilePrefab, launchPoint.position, launchPoint.rotation);
            RealisticMissile missileScript = missile.GetComponent<RealisticMissile>();
            if (missileScript != null)
            {
                missileScript.targetTag = targetTag;
            }
        }
    }
}