using UnityEngine;

public class MoveForward : MonoBehaviour
{
    public float speed = 5f;              
    public float lifetime = 3f;          
    public Vector3 rotationSpeed = new Vector3(90f, 90f, 90f);

    private float timer;

    void Start()
    {
        timer = lifetime;
    }

    void Update()
    {
        transform.Translate(Vector3.forward * speed * Time.deltaTime);

        transform.Rotate(rotationSpeed * Time.deltaTime);

        timer -= Time.deltaTime;

        if (timer <= 0f)
        {
            Destroy(gameObject);
        }
    }
}
